<?php

namespace App\Entity;
use App\Repository\UtilisateurRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Security\Core\User\PasswordAuthenticatedUserInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Uid\Uuid;

#[ORM\Entity(repositoryClass: UtilisateurRepository::class)]
#[ORM\Table(name:"utilisateur")]
class Utilisateur implements UserInterface, PasswordAuthenticatedUserInterface
{
    #[ORM\Id]
    #[ORM\Column(name: 'id', type: 'uuid')]
    private Uuid $id;

    #[ORM\Column(name:"password", type:"string")]
    protected string $password;

    #[ORM\Column(name:"identifiant", type:"string")]
    protected string $identifiant;

    #[ORM\Column(name:"roles", type:"json")]
    protected array $roles;

    /**
     * @param Uuid $id
     * @param string $password
     * @param string $identifiant
     * @param array $roles
     */
    public function __construct(Uuid $id, string $password, string $identifiant, array $roles)
    {
        $this->id = $id;
        $this->password = $password;
        $this->identifiant = $identifiant;
        $this->roles = $roles;
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @param Uuid $id
     */
    public function setId(Uuid $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    /**
     * @param string $password
     */
    public function setPassword(string $password): void
    {
        $this->password = $password;
    }

    /**
     * @return string
     */
    public function getIdentifiant(): string
    {
        return $this->identifiant;
    }

    /**
     * @param string $identifiant
     */
    public function setIdentifiant(string $identifiant): void
    {
        $this->identifiant = $identifiant;
    }

    /**
     * @return array
     */
    public function getRoles(): array
    {
        return $this->roles;
    }

    /**
     * @param array $roles
     */
    public function setRoles(array $roles): void
    {
        $this->roles = $roles;
    }



    public function eraseCredentials(): void
    {
// TODO: Implement eraseCredentials() method.
    }
    public function getUserIdentifier(): string
    {
        return (string) $this->identifiant;
    }
}