<?php

namespace App\Service;

use Symfony\Contracts\HttpClient\HttpClientInterface;

class AdresseApiService
{
    private $client;

    public function __construct(HttpClientInterface $client)
    {
        $this->client = $client;
    }

    public function searchAddress(string $query): array
    {
        $response = $this->client->request('GET', 'https://api-adresse.data.gouv.fr/search/', [
            'query' => [
                'q' => $query,
            ],
        ]);

        if ($response->getStatusCode() !== 200) {
            throw new \Exception('Failed to fetch data from the API');
        }

        $data = $response->toArray();

        return $data['features'] ?? [];
    }

    public function reverseGeocode(float $latitude, float $longitude): array
    {
        $response = $this->client->request('GET', 'https://api-adresse.data.gouv.fr/reverse/', [
            'query' => [
                'lat' => $latitude,
                'lon' => $longitude,
            ],
        ]);

        if ($response->getStatusCode() !== 200) {
            throw new \Exception('Failed to fetch data from the API');
        }

        $data = $response->toArray();

        return $data['features'] ?? [];
    }
}