<?php

namespace App\Controller;

use App\Service\AdresseApiService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class AdresseApiController extends AbstractController
{
    private $adresseApiService;

    public function __construct(AdresseApiService $adresseApiService)
    {
        $this->adresseApiService = $adresseApiService;
    }

    #[Route('/autocomplete-address', name: 'autocomplete_address')]
    public function autocomplete(Request $request): Response
    {
        $query = $request->query->get('q', '');
        $results = $this->adresseApiService->searchAddress($query);

        // Format the response for jQuery UI Autocomplete
        $suggestions = array_map(function($feature) {
            return [
                'label' => $feature['properties']['label'],
                'value' => $feature['properties']['label']
            ];
        }, $results);

        return $this->json($suggestions);
    }

    #[Route('/search-address', name: 'search_address')]
    public function search(Request $request): Response
    {
        $query = $request->query->get('q', '');
        $results = $this->adresseApiService->searchAddress($query);

        return $this->json($results);
    }

    #[Route('/reverse-geocode', name: 'reverse_geocode')]
    public function reverseGeocode(Request $request): Response
    {
        $latitude = $request->query->get('lat');
        $longitude = $request->query->get('lon');
        $results = $this->adresseApiService->reverseGeocode($latitude, $longitude);

        return $this->json($results);
    }
}